<?php
ini_set('max_execution_time', '0'); // for infinite time of execution 

start();

function start() // funkcja główna w której uruchamiamy cały proces 
{
	$config = parse_ini_file("SystimConfig.ini",true, INI_SCANNER_RAW); // pobieramy dane z konfiguracji
	
	$systimOrders = getSystimOrder($config); //pobieramy zamówienia z systim
	
	$orders = getOrders($config);// pobieramy zamówienia z ido
	
	foreach($orders as $key=>$order)
	{
		
		$order_date = $order['orderDetails']['orderAddDate'];
		$order_price = $order['orderDetails']['payments']['orderBaseCurrency']['orderProductsCost'];
		$delivery_price = $order['orderDetails']['payments']['orderBaseCurrency']['orderDeliveryCost'];
		$order_first_name = $order['clientResult']['clientBillingAddress']['clientFirstName'];
		$order_last_name = $order['clientResult']['clientBillingAddress']['clientLastName'];
		$order_company = $order['clientResult']['clientBillingAddress']['clientFirm'];
		$order_nip = $order['clientResult']['clientBillingAddress']['clientNip'];
		
		$order_cost = round($order_price + $delivery_price,2);
		
		foreach($systimOrders as $key1=>$si) // sprawdzamy czy dane zamówienie figuruje w systim, jeśli tak usuwamy je z listy zamówień do wysłania
		{
			
			if(date("Y-m-d H:i:s",strtotime($si['data_zlozenia']))==date("Y-m-d H:i:s",strtotime($order_date)))	//sprawdzamy czy daty zamowień z ido i systim się pokrywają 
			{
				
				if($si['suma_brutto']==$order_cost) // sprawdzamy czy ceny brutto zamówień z ido i systim się pokrywają 
				{
					
					if((($si['imie']==$order_first_name && $si['nazwisko']==$order_last_name) || ($si['nazwa']==$order_company && $si['nip']==$order_nip))) // sprawdzamy czy osoba zamawiająca lub firma zamawiająca sie pokrywają 
					{
						
						unset($orders[$key]); //jeśli wszystkie warunki są spełnione usuwamy zamówienie z listy
						unset($systimOrders[$key1]);
						
					}
					else if($si['imie_zam'] == $order_first_name && $si['nazwisko_zam'] == $order_last_name) // sprawdzamy czy osoba zamawiająca
					{
						unset($orders[$key]); //jeśli wszystkie warunki są spełnione usuwamy zamówienie z listy
						unset($systimOrders[$key1]);
					}
				}
			}
		}
	}
	
	addOrder($config['Systim'],$orders); //dodanie zamówienia do systim
}

function getOrders($config) // funkcja pobierająca zamówienia z ido z konkretnego okresu czasu
{	
	$address = $config['IdoSell']['idoUrl'].'/api/?gate=orders/get/132/json';
	
	$request['authenticate'] = array(); 
	$request['authenticate']['userLogin'] = $config['IdoSell']['idoLogin'];
	$request['authenticate']['authenticateKey'] = sha1(date('Ymd') . sha1($config['IdoSell']['idoPassword']));
	
	
	$request['params'] = array();
	$request['params']['ordersStatuses'] = array();
	$request['params']['ordersStatuses'][0] = "finished";
	
	// tutaj określamy z jakiego okresu zamówienia mają sie dodawać, oraz jaką date bierzemy pod uwage
	$request['params']['ordersRange'] = array();
	$request['params']['ordersRange']['ordersDateRange'] = array();
	$request['params']['ordersRange']['ordersDateRange']['ordersDateType'] = 'add';
	
	$request['params']['ordersRange']['ordersDateRange']['ordersDatesTypes'] = array();
	$request['params']['ordersRange']['ordersDateRange']['ordersDatesTypes'][0] = 'add';
	
	$date=date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -'.$config['Config']['days'].' days'));
	$date1=date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s')));
	
	$request['params']['ordersRange']['ordersDateRange']['ordersDateBegin'] = $date;
	$request['params']['ordersRange']['ordersDateRange']['ordersDateEnd'] = $date1;
	
	
	$request_json = json_encode($request);
	$headers = array(
		'Accept: application/json',
		'Content-Type: application/json;charset=UTF-8'
	);

	$curl = curl_init($address);
	curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
	curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
	curl_setopt($curl, CURLOPT_HEADER, 0);
	curl_setopt($curl, CURLOPT_POST, 1);
	curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
	curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

	$response = curl_exec($curl);
	$status = curl_getinfo($curl, CURLINFO_HTTP_CODE );
	
	curl_close($curl);
	
	$dane = json_decode($response,true);
	
	
	if($dane['errors']['faultCode'] == 0)
	{
		$arr = array();
		
		$orders = $dane['Results'];
		
		foreach($orders as $order)
		{
			$order['id'] = $order['orderSerialNumber'];	
			$order["orderDetails"]['orderAddDate'] = date("Y-m-d H:i",strtotime($order["orderDetails"]['orderAddDate']));
			
			array_push($arr,$order);
		}
		
		return $arr;
	}
	else
	{
		die($dane['errors']['faultString']);
	}
}

function getId($code,$arr) // fukncja pobierająca id produktu w systim 
{
	
	$c = curl_init();
	curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
	curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
	curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listProducts'.
			   '&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken'])); 
	curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
	
	$wynik = curl_exec($c);
	
	curl_close($c);
	
	$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
	  
	if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
																//jeśli tak, wyświetlamy go	 
	// wyświetlamy te informacje dotyczące produktu które chcemy
 
	foreach($dane['result'] as $id=>$product)
	{
		if($product['kod_produktu']==$code)
		{
			return $id;
		}
		
	} 
}

function prepareOrder($products,$delivery,$arr) // funkcja wprowadzająca produkty do array i poddający go kodowaniu w celu dodania do curl'a
{
	$produktyARR = array();
	$i =0;
	
	foreach($products as $product)
	{
		if(!empty($product))
		{
			$id = getId($product['productCode'],$arr);
			$produktyARR['produkty'][$i] = array('id'=>$id,'ilosc'=>intval($product['productQuantity']),'price'=>$product['productOrderPrice'],'tax'=>$product['productVat']);
			$i++;
		}
	}
	
	if($i>0)
	{
		$delivery_id = getServiceId($delivery['name'],$arr);
		
		$produktyARR['produkty'][$i] = array('id'=>intval($delivery_id),'ilosc'=>1, 'price'=>$delivery['price'], 'tax'=>$delivery['tax']);
			
	}
	
	
	return $produkty =  urldecode(http_build_query($produktyARR));
}

function getKontrahentId($systimCompanies,$nip,$companyName)
{
	foreach($systimCompanies as $id=>$company)
	{
		if($nip!='' && $nip == $company['nip'])
		{
			return $id;
		}
		else if($companyName == $company['nazwa'])
		{
			return $id;
		}
	}

	return;
}

function getZamawiajacyId($systimCustomers,$firstName,$lastName,$idKontrahent)
{
	foreach($systimCustomers as $id=>$customer)
	{
		if($firstName==$customer['imie'] && $lastName == $customer['nazwisko'] && $customer['id_kontrahenta'] == $idKontrahent)
		{
			return $id;
		}
	}
	return;
}

function prepareBody($client, $delivery)
{
	$order_info = '';
	
	foreach($client as $key => $value)
	{
		$order_info = $order_info.'&'.$key.'='.$value;
	}
	
	foreach($delivery as $key => $value)
	{
		if($value=='')
		{
			$value = $client[$key];
		}
		$order_info = $order_info.'&'.$key.'_dostawy='.$value;
	}
		
	return $order_info;
	
}

function addOrder($arr,$idoArr) // fukncja zamówień z ido do systim
{	
	$companies = getCompanies($arr);
	$customers = getCustomers($arr);
	
	foreach($idoArr as $ia)
	{

		$body ="";
		$idK=0;
		$idZ=0;
		
		$order_id = $ia['orderSerialNumber'];
		
		$ordered_date = $ia['orderDetails']['orderAddDate'];
		
		$nip = str_replace("_","",str_replace(" ","",str_replace("-","",$ia['clientResult']['clientBillingAddress']['clientNip'])));
		$client_company = $ia['clientResult']['clientBillingAddress']['clientFirm'];
		
		$client_name = $ia['clientResult']['clientBillingAddress']['clientFirstName'];
		$client_surname = $ia['clientResult']['clientBillingAddress']['clientLastName'];
		
		$client_city = $ia['clientResult']['clientBillingAddress']['clientCity'];
		$client_street = $ia['clientResult']['clientBillingAddress']['clientStreet'];
		$client_postcode = $ia['clientResult']['clientBillingAddress']['clientZipCode'];
		
		$email = $ia['clientResult']['clientAccount']['clientEmail'];
		$client_phone1 = $ia['clientResult']['clientBillingAddress']['clientPhone1'];
		$client_phone2 = $ia['clientResult']['clientBillingAddress']['clientPhone2'];
		
		
		$delivery['price'] = $ia['orderDetails']['payments']['orderBaseCurrency']['orderDeliveryCost'];
		$delivery['tax'] = round($ia['orderDetails']['payments']['orderBaseCurrency']['orderDeliveryVat']);
		$delivery['name'] = $ia['orderDetails']['dispatch']['courierName'];
		
		
		$delivery_name = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressFirstName'];
		$delivery_surname = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressLastName'];
		
		$delivery_company = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressFirm'];
		
		$delivery_city = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressCity'];
		$delivery_street = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressStreet'];
		
		$delivery_postcode = (isset($ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressZipCode']) ? $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressZipCode'] : '');
		
		$delivery_phone1 = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressPhone1'];
		$delivery_phone2 = $ia['clientResult']['clientDeliveryAddress']['clientDeliveryAddressPhone2'];
		
		$products = $ia['orderDetails']['productsResults'];
		
		$payment_method = $ia['orderDetails']['payments']['orderPaymentType'];
		
		if($client_company=='')
		{
			$client_company = $client_name.' '.$client_surname;
		}
		if($delivery_company=='')
		{
			$delivery_company = $delivery_name.' '.$delivery_surname;
		}
		
		
		$client_phone = ($client_phone1 != '' ? $client_phone1 : $client_phone2);
		$delivery_phone = ($delivery_phone1 != '' ? $delivery_phone1 : $delivery_phone2);
		
		$billing_info = array(
			'nazwa' => $client_company,
			'nip' => $nip,
			'kod' => $client_postcode,
			'miejscowosc' => $client_city,
			'ulica' => $client_street,
			'imie' => $client_name,
			'nazwisko' => $client_surname,
			'email' => $email,
			'telefon' => $client_phone
		);
		
		$delivery_info = array(
			'nazwa' => $delivery_company,
			'kod' => $delivery_postcode,
			'miejscowosc' => $delivery_city,
			'ulica' => $delivery_street,
			'imie' => $delivery_name,
			'nazwisko' => $delivery_surname,
			'telefon' => $delivery_phone
		);
		
		$idK = getKontrahentId($companies,$nip,$client_company);
		$idZ = getZamawiajacyId($customers,$client_name,$client_surname,$idK);
		
		$id_dostawy = getDeliveryId($ia['orderDetails']['dispatch']['courierName'],$arr); //sprawdza ID dostawy, jesli nie znajdzie dostawy o podanej nazwie zwraca 5
		
		$body = '&id_kontrahenta='.$idK.'&id_zamawiajacego='.$idZ;
		
		$order_information = prepareBody($billing_info, $delivery_info);
		
		
		$produkty = prepareOrder($products,$delivery,$arr);
		
		//przygotowanie danych odnośnie zamawiających, oraz dostawców
		
		
		
			$c = curl_init();
				curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
				curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
				curl_setopt($c, CURLOPT_POSTFIELDS, 'act=addOrder'.
						'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken']).
						$order_information.
					   '&id_dostawy='.$id_dostawy.
					   '&id_formy_platnosci='.$payment_method.
					   '&data_wystawienia='.$ordered_date.
					   '&naliczanie_brutto=1'.
					   '&'.$produkty.
					   $body);  //id_dostawy=1 - przesyłka kurierska
				curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
				$wynik = curl_exec($c);
				curl_close($c);
			$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
			
			if($dane['error']['code']>0)
			{
				$fields = implode(', ', $dane['error']['fields']);
				
				echo "Zamówienie numer ".$order_id .": ". $dane['error']['message'] ." ". $fields."<br>" ;
			}	
			
			
	}
}
function getDeliveryId($name,$arr) // funkcja pobierająca id dostawy
{
	
	$c = curl_init();
		curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listDeliveryTypes'.
				'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken'])); //dane do wysłania
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		$wynik = curl_exec($c);
		curl_close($c);
	$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
	 
	if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
																//jeśli tak, wyświetlamy go
	$toSend = "5";
	foreach($dane['result'] as $id=>$nazwa)
	{
		if($nazwa == $name)
		{
			$toSend = $id;
			break;
		}
		
	}
	return $toSend;
}

function getServiceId($name,$arr) // funkcja pobierająca id dostawy z listy produktów (usług)
{
	
	$c = curl_init();
		curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listServices'.'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken'])); //dane do wysłania
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		
	$wynik = curl_exec($c);
		
	curl_close($c);
		
	$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
	 
	if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
																//jeśli tak, wyświetlamy go
	
	$serviceId = NULL;
	
	foreach($dane['result'] as $id=>$service)
	{
		
		if($service == $name)
		{
			
			return $id;
		}
	}
	
	$serviceId = addService($name, 'flat_rate', $arr);
	
	return $serviceId;
	
}

function addService($name, $sku, $arr)
{
	
	$c = curl_init();
	curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
	curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
	curl_setopt($c, CURLOPT_POSTFIELDS, 'act=addProduct'.
		'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken']).
		'&nazwa='.$name.
		'&kod_kreskowy='.$sku.
		'&cena_brutto=0'.
		'&cena_netto=0'.
		'&stawka_vat=1'.
		'&id_kategorii='.intval(13).
		'&rodzaj='.intval(1)
	);
	curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
	
	$wynik = curl_exec($c);
	
	curl_close($c);
	
	$dane = json_decode($wynik,true);
	
	if($dane['error']['code']>0) die($dane['error']['message']);
	
	return $dane['result'];

}

function getSystimOrder($arr)//funkcja pobierająca zamówienia z systim
{
	$days = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -'.$arr['Config']['days'].' days'));
	$data_do = date("Y-m-d H:i:s");
	$c = curl_init();
	curl_setopt($c, CURLOPT_URL, 'https://'.$arr['Systim']['numerKontaSystim'].'.systim.pl/jsonAPI.php');
	curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
	curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listOrders'.
			   '&login='.urlencode($arr['Systim']['systimLogin']).''. '&pass='.urlencode($arr['Systim']['systimUserToken'])
			   .'&data_zlozenia_do='.$data_do.'
			   &data_zlozenia_od='.$days); 
	curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
	$wynik = curl_exec($c);
	curl_close($c);
	$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
	 
	if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
															   //jeśli tak, wyświetlamy go
																
	 return $dane['result'];
}
function getCompanies($arr)
{
	$c = curl_init();
		curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listCompanies'.
											'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken'])); 
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		
		$wynik = curl_exec($c);
		
		curl_close($c);
		
		$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
		
		if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
															   //jeśli tak, wyświetlamy go
		return $dane['result'];
}

function getCustomers($arr)
{
	$c = curl_init();
		curl_setopt($c, CURLOPT_URL, 'https://'.$arr['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listCustomers'.
					'&login='.urlencode($arr['systimLogin']).''. '&pass='.urlencode($arr['systimUserToken'])); //dane do wysłania
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		
		$wynik = curl_exec($c);
		
		curl_close($c);
		
		$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
	 
		if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
																//jeśli tak, wyświetlamy go
		return $dane['result'];
}

function prepareCompId($idK,$login="",$token="",$url="",$nip=0,$nazwa="",$miejscowosc="",$ulica="",$kod="")
{
	$body = "";
	if($idK==0) // tworzenie nowego kontrahenta
	{
		if($nip==0)
		{
			$temp = "";
		}
		else
		{
			$temp = "&nip=".$nip;
		}
		$c = curl_init();
			curl_setopt($c, CURLOPT_URL, 'https://'.$url.'.systim.pl/jsonAPI.php');
			curl_setopt($c, CURLOPT_POST, true); //sposób przesyłania - (true metoda POST)
			curl_setopt($c, CURLOPT_POSTFIELDS, 'act=addCompany'.
				   '&login='.urldecode($login).''. '&pass='.urlencode($token).
				   '&nazwa='.$nazwa.
				   '&miejscowosc='.$miejscowosc.
				   '&ulica='.$ulica.
				   '&kod='.$kod.
				   $temp); 
			curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
			$wynik = curl_exec($c);
			curl_close($c);
			$dane = json_decode($wynik,true); // wartości w postaci tablicy asocjacyjnej
			//print_r($dane['error']);
			if($dane['error']['code']>0) die($dane['error']['message']); //sprawdzamy czy wystąpił jakiś błąd, 
																	   //jeśli tak, wyświetlamy go
			$body ="&id_kontrahenta=".$dane['result'];
	}
	else // dodanie istniejącego
	{
		$body="&id_kontrahenta=".$idK;
	}
	return $body;
}

function prepareSellerBody($idZ,$imie="",$nazwisko="")
{
	$body = "";
	if($idZ==0) // tworzenie nowego zamawiającego
	{
		$body = "&imie=".$imie.'&nazwisko='.$nazwisko;
	}
	else // dodanie istniejącego zamawiającego
	{
		
		$body="&id_zamawiajacego=".$idK;
	}
	return $body;
}

