<?php
ini_set('max_execution_time', '0'); // for infinite time of execution 

	start();
	
	function start() // główna funkcja w której wyciągamy kategorie i wysyłamy dane do następnych funkcji 
	{
		
		$config = parse_ini_file("SystimConfig.ini",true, INI_SCANNER_RAW);

		$c = curl_init();
		curl_setopt($c, CURLOPT_URL, 'https://'.$config['Systim']['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); 
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listCategories'.
				   '&login='.urlencode($config['Systim']['systimLogin']).''. '&pass='.urlencode($config['Systim']['systimUserToken'])); 
				   
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		
		$wynik = curl_exec($c);
		
		curl_close($c);
		
		$dane = json_decode($wynik,true); 
		
		if($dane['error']['code']>0) die($dane['error']['message']);  
		
		if($config['Config']['categoriesWithProducts']==1)//jeżeli jest zgoda na synchronizacje produktów wraz z kategoriami 
		{
			synchronizeCategories($config,$dane['result']); // dodanie kategorii z systim do ido
		}
		
		synchronizeProducts($config,$dane['result']); //dodanie produktów z systim do ido
		
	}

	function synchronizeCategories($arr,$data) // aktualizacja kategorii
	{                               // sprawdza kategorie pobrane z systim z kategoriami w ido i dodaje te których nie ma
		getIaiCategories($arr['IdoSell'],$data);
		
	}
	
	function synchronizeProducts($arr,$data) // aktualizacja produktów 
	{										//funkcja pobiera produkty z systim, 
											// a następnie wysyła je do zapisania
		$c = curl_init();
		
		curl_setopt($c, CURLOPT_URL, 'https://'.$arr['Systim']['numerKontaSystim'].'.systim.pl/jsonAPI.php');
		curl_setopt($c, CURLOPT_POST, true); 
		curl_setopt($c, CURLOPT_POSTFIELDS, 'act=listProducts'.'&login='.urlencode($arr['Systim']['systimLogin']).''. 
					'&pass='.urlencode($arr['Systim']['systimUserToken'])); 
					
		curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
		
		$wynik = curl_exec($c);
		
		curl_close($c);
		
		$dane = json_decode($wynik,true); 
		  
		if($dane['error']['code']>0) die($dane['error']['message']); 
		
		$prepare = array();
		
		foreach($dane['result'] as $daneRes)
		{
			foreach($data as $id=>$d)
			{
				if($daneRes['id_kategorii']==$id && $daneRes['kod_produktu']!=null)
				{
					$daneRes['kategoria'] = $d['nazwa'];
				}
				
			}
			array_push($prepare,$daneRes);
		}
		
		
		
		getIaiProducts($arr['IdoSell'],$prepare,$arr['Config']['productsWithQty']);
	}
	
	function generateToken($pass)//generator tokenów do IdoSell
	{
		return sha1(date('Ymd').sha1($pass));
	}
	
	function getIaiCategories($idoArr,$arr) // pobranie kategorii z ido 
	{
		$address = $idoArr['idoUrl'].'/api/?gate=productscategories/get/130/json';

		$request = array();
		$request['authenticate'] = array();
		$request['authenticate']['system_key'] = generateToken($idoArr['idoPassword']);
		$request['authenticate']['system_login'] = $idoArr['idoLogin'];

		$request_json = json_encode($request);
		$headers = array(
			'Accept: application/json',
			'Content-Type: application/json;charset=UTF-8'
		);

		$curl = curl_init($address);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		$status = curl_getinfo($curl,CURLINFO_HTTP_CODE);
		
		curl_close($curl);
		
		$main = json_decode($response,true);
			
			
		foreach($arr as $data) //sprawdzamy czy poszczególne kategorie figurują w ido
		{						// jeśli jakiejś kategorii nie ma, to jest wysyłana do sklepu
			$licznik =0;
			$id = 0;
			
			foreach($main as $cat)
			{ 
				if(is_array($cat))
				{
					foreach($cat as $c)
					{
						if(isset($c['lang_data'][0]))
						{
							if($c['lang_data'][0]['singular_name']==$data['nazwa'] || $c['lang_data'][0]['plural_name']==$data['nazwa'])
							{
								$licznik++;
								
							}
						}
					}
				}
			}
			
			if($licznik==0)
			{
				postCategories($idoArr,$data['nazwa']);
			}
		}
		
		if($status != 200 || $status < 200 || $status > 299)
		{
			print_r(json_decode($response,true));
		}
	}
	
	function postCategories($idoArr,$nazwa)// dodanie kategorii do ido 
	{
		$address = $idoArr['idoUrl'].'/api/?gate=productscategories/update/130/json';

		$request = array();
		$request['authenticate'] = array(); //podanie danych do autentykacji
		$request['authenticate']['system_key'] = generateToken($idoArr['idoPassword']);
		$request['authenticate']['system_login'] = $idoArr['idoLogin'];
		$request['params'] = array();
		$request['params']['categories'] = array();
		$request['params']['categories'][0] = array(); //nadanie kategorii nazwy w języku polskim
		$request['params']['categories'][0]['priority'] = 3;
		$request['params']['categories'][0]['operation'] = 'add';
		$request['params']['categories'][0]['lang_data'] = array();
		$request['params']['categories'][0]['lang_data'][0] = array();
		$request['params']['categories'][0]['lang_data'][0]['lang_id'] = "pol";
		$request['params']['categories'][0]['lang_data'][0]['singular_name'] = $nazwa;
		$request['params']['categories'][0]['lang_data'][0]['plural_name'] = $nazwa;

		$request_json = json_encode($request);
		$headers = array(
			'Accept: application/json',
			'Content-Type: application/json;charset=UTF-8'
		);

		$curl = curl_init($address);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
		curl_setopt($curl, CURLOPT_HEADER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		$status = curl_getinfo($curl,CURLINFO_HTTP_CODE);
		
		curl_close($curl);
		
		if($status != 200||$status<200||$status>2990)
		{
			print_r(json_decode($response,true));
		}
	}
	
	function getIaiProducts($idoArr,$arr,$withQty) // pobieranie produktów z ido
	{												// jeśli jest już produkt o danym kodzie, następuje aktualizacja, 
													// w przeciwnym razie produkt jest dodawany
		foreach($arr as $dane)
		{
			$i=0;
			$toCheck = array();			
			$address = $idoArr['idoUrl'].'/api/?gate=products/get/130/json';
			$request = array();
			$request['authenticate'] = array();
			$request['authenticate']['userLogin'] =$idoArr['idoLogin'];
			$request['authenticate']['authenticateKey'] = generateToken($idoArr['idoPassword']);
			$request['params'] = array();
			$request['params']['productIsVisible'] = "y";
			$request['params']['productParams'] = array();
			$request['params']['productParams'][0] = array();
			$request['params']['productParams'][0]['productCode'] = $dane['kod_produktu'];

			$request_json = json_encode($request);
			$headers = array(
				'Accept: application/json',
				'Content-Type: application/json;charset=UTF-8'
			);

			$curl = curl_init($address);
			curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

			$response = curl_exec($curl);
			$status = curl_getinfo($curl,CURLINFO_HTTP_CODE);
			curl_close($curl);
			
			$output = json_decode($response,true)['results'];
			
			if($status != 200||$status<200||$status>299)
			{	
				
				print_r(json_decode($response,true));
		   
			}
			if(empty($output))
			{
				postIAIProduct($idoArr,$dane,$withQty); //wysłanie produktu do dodania
			}
			else
			{
				$id = $output[0]['productId'];	
				updateIAIProduct($idoArr,$dane,$id,$withQty); // wysłanie produktu do aktualizacji
			}
		}	
			
	}
	
	function postIAIProduct($idoArr,$arr,$withQty) //dodanie produktu z sytsim do sklepu, jeśli ustawiliśmy withQty na 1 
	{												// razem z produktem zostaną zaktualizowane stany magazynowe
		$address = $idoArr['idoUrl'].'/api/?gate=products/insert/130/json';

		$request = array();
		$request['authenticate'] = array();// dane autentykacji
		$request['authenticate']['userLogin'] = $idoArr['idoLogin'];
		$request['authenticate']['authenticateKey'] = generateToken($idoArr['idoPassword']);
		$request['params'] = array();
		$request['params']['settings'] = array();
		$request['params']['settings']['settingAddingCategoryAllowed'] = "y";
		$request['params']['settings']['settingAddingSizeAllowed'] = "y";
		$request['params']['settings']['settingAddingProducerAllowed'] = "y";
		$request['params']['settings']['settingAddingSeriesAllowed'] = "y";
		$request['params']['products'] = array();
		$request['params']['products'][0] = array(); // dane produktu
		$request['params']['products'][0]['productSizeCodeDependentData'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'][0] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'][0]['stockId'] = 1;
		$request['params']['products'][0]['shopsMask'] = 1;
		$request['params']['products'][0]['productDisplayedCode'] = $arr['kod_produktu'];
		$request['params']['products'][0]['categoryName'] = $arr['kategoria'];
		$request['params']['products'][0]['priceChangeMode'] = "amount_set";
		$request['params']['products'][0]['productRetailPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productWholesalePrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productMinimalPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productPosPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productVat'] = strtok($arr['stawka_vat'],'%');
		$request['params']['products'][0]['productVatFree'] = "n";
		$request['params']['products'][0]['productEnableInPos'] = "n";
		$request['params']['products'][0]['productInVisible'] = "y";
		$request['params']['products'][0]['productInPersistent'] = "y";
		$request['params']['products'][0]['productInExportToPriceComparisonSites'] = "n";
		$request['params']['products'][0]['productInExportToAmazonMarketplace'] = "n";
		$request['params']['products'][0]['productNames'] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'][0] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productNames']['productNamesLangData'][0]['productName'] = $arr['nazwa'];
		$request['params']['products'][0]['productDescriptions'] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0]['productDescription'] = $arr['opis'];
		$request['params']['products'][0]['productLongDescriptions'] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0]['productLongDescription'] = $arr['opis'];
		$request['params']['products'][0]['productMetaTitles'] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['langName'] = "polski";
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['productMetaTitle'] = $arr['nazwa'];
		$request['params']['products'][0]['productMetaDescriptions'] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['langName'] = "polski";
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['productMetaDescription'] = $arr['opis'];
		$request['params']['products'][0]['currencyId'] = "PLN";
		$request['params']['products'][0]['productParametersDistinctionChangeMode'] = 'add';
		$request['params']['products'][0]['productDeliveryTime'] = array();
		$request['params']['products'][0]['productDeliveryTime']['productDeliveryTimeChangeMode'] = 'deliverer';
		$request['params']['products'][0]['productDeliveryTime']['productDeliveryTimeValue'] = 10;
		$request['params']['products'][0]['productSumInBasket'] = "y";

		$request_json = json_encode($request);
		$headers = array(
			'Accept: application/json',
			'Content-Type: application/json;charset=UTF-8'
		);

		$curl = curl_init($address);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
		curl_setopt($curl, CURLOPT_HEADER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		
		$status = curl_getinfo($curl, CURLINFO_HTTP_CODE );
		curl_close($curl);
		
		if($status != 200 || $status < 200 || $status > 299) // jeśli status code nie jest równy 200 wyświetli błąd na ekranie
		{
			print_r(json_decode($response,true));
			
		}
		else //w przeciwnym razie następuhe aktualizacja stanow magazynowych, o ile wyraziliśmy zgodę w konfiguracji
		{
		   
			$xd = json_decode($response,true);
			$id = $xd['results']['productsResults'][0]['productId'];
			
			if($withQty==1) 
			{
				setQty($idoArr,$arr['ilosc'],$id);
			}
		}
	}
	
	function updateIAIProduct($idoArr,$arr,$id,$withQty) //aktualizacja produktów
	{
		$address = $idoArr['idoUrl'].'/api/?gate=products/update/130/json';

		$request = array();
		$request['authenticate'] = array();//ustawienia autentykacji
		$request['authenticate']['userLogin'] = $idoArr['idoLogin'];
		$request['authenticate']['authenticateKey'] = generateToken($idoArr['idoPassword']);
		$request['params'] = array();
		$request['params']['settings'] = array();
		$request['params']['settings']['settingAddingCategoryAllowed'] = "y";
		$request['params']['settings']['settingAddingSizeAllowed'] = "y";
		$request['params']['settings']['settingAddingProducerAllowed'] = "y";
		$request['params']['settings']['settingAddingSeriesAllowed'] = "y";
		$request['params']['products'] = array();
		$request['params']['products'][0] = array();// dane odnośnie produktu
		$request['params']['products'][0]['productId'] = $id;
		$request['params']['products'][0]['productSizeCodeDependentData'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'][0] = array();
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'][0]['stockId'] = 1;
		$request['params']['products'][0]['productSizeCodeDependentData']['productStocksData']['productStockQuantities'][0]['productSizeQuantityToAdd'] =200;
		$request['params']['products'][0]['shopsMask'] = 1;
		$request['params']['products'][0]['productDisplayedCode'] = $arr['kod_produktu'];
		$request['params']['products'][0]['categoryName'] = $arr['kategoria'];
		$request['params']['products'][0]['priceChangeMode'] = "amount_set";
		$request['params']['products'][0]['productRetailPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productWholesalePrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productMinimalPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productPosPrice'] = $arr['cena_brutto'];
		$request['params']['products'][0]['productVat'] =  strtok($arr['stawka_vat'],'%');
		$request['params']['products'][0]['productVatFree'] = "n";
		$request['params']['products'][0]['productEnableInPos'] = "n";
		$request['params']['products'][0]['productInVisible'] = "y";
		$request['params']['products'][0]['productInPersistent'] = "y";
		$request['params']['products'][0]['productInExportToPriceComparisonSites'] = "n";
		$request['params']['products'][0]['productInExportToAmazonMarketplace'] = "n";
		$request['params']['products'][0]['productNames'] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'][0] = array();
		$request['params']['products'][0]['productNames']['productNamesLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productNames']['productNamesLangData'][0]['productName'] = $arr['nazwa'];
		$request['params']['products'][0]['productDescriptions'] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productDescriptions']['productDescriptionsLangData'][0]['productDescription'] = $arr['opis'];
		$request['params']['products'][0]['productLongDescriptions'] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productLongDescriptions']['productLongDescriptionsLangData'][0]['productLongDescription'] = $arr['opis'];
		$request['params']['products'][0]['productMetaTitles'] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0] = array();
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['langName'] = "polski";
		$request['params']['products'][0]['productMetaTitles']['productMetaTitlesLangData'][0]['productMetaTitle'] = $arr['nazwa'];
		$request['params']['products'][0]['productMetaDescriptions'] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0] = array();
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['langId'] = "pol";
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['langName'] = "polski";
		$request['params']['products'][0]['productMetaDescriptions']['productMetaDescriptionsLangData'][0]['productMetaDescription'] = $arr['opis'];
		$request['params']['products'][0]['currencyId'] = "PLN";
		$request['params']['products'][0]['productParametersDistinctionChangeMode'] = 'add';
		$request['params']['products'][0]['productDeliveryTime'] = array();
		$request['params']['products'][0]['productDeliveryTime']['productDeliveryTimeChangeMode'] = 'deliverer';
		$request['params']['products'][0]['productDeliveryTime']['productDeliveryTimeValue'] = 10;
		$request['params']['products'][0]['productSumInBasket'] = "y";

		$request_json = json_encode($request);
		$headers = array(
			'Accept: application/json',
			'Content-Type: application/json;charset=UTF-8'
		);

		$curl = curl_init($address);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
		curl_setopt($curl, CURLOPT_HEADER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		$status = curl_getinfo($curl, CURLINFO_HTTP_CODE );
		
		curl_close($curl);
		
		if($status != 200 || $status < 200 || $status > 299) // jeżeli status code nie jest równu 200 to wyświetli błąd
	    {
			print_r(json_decode($response,true));
		}
		else // w przeciwnym razie aktualizuje stany magazynowe jeżeli wyraziliśmy chęć w konfiguracji
		{
			if($withQty==1)
			{
				setQty($idoArr,$arr['ilosc'],$id);
				
			}
			
		}
	}
	
	function setQty($idoArr,$qty,$id)
	{
		$address = $idoArr['idoUrl'].'/api/?gate=productsstocks/set/130/json';
		$request = array();
		$request['authenticate'] = array(); // dane do autentykacji
		$request['authenticate']['system_key'] = generateToken($idoArr['idoPassword']);
		$request['authenticate']['system_login'] = $idoArr['idoLogin'];
		$request['params'] = array();
		$request['params']['products'] = array(); // dane odnośnie id oraz stanu magazynowego produktu który chcemy edytować 
		$request['params']['products'][0] = array();
		$request['params']['products'][0]['ident'] = array();
		$request['params']['products'][0]['ident']['identType'] = 'id';
		$request['params']['products'][0]['ident']['identValue'] = $id;
		$request['params']['products'][0]['sizes'] = array();
		$request['params']['products'][0]['sizes'][0] = array();
		$request['params']['products'][0]['sizes'][0]['ident'] = array();
		$request['params']['products'][0]['sizes'][0]['ident']['identType'] = 'id';
		$request['params']['products'][0]['sizes'][0]['ident']['identValue'] = 'uniw';
		$request['params']['products'][0]['sizes'][0]['quantity'] = array();
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'] = array();
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'][0] = array();
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'][0]['stock_id'] = 1;
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'][0]['quantity_operation'] = array();
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'][0]['quantity_operation']['operation'] = 'set';
		$request['params']['products'][0]['sizes'][0]['quantity']['stocks'][0]['quantity_operation']['quantity'] = intval($qty);
		$request_json = json_encode($request);
		$headers = array(
			'Accept: application/json',
			'Content-Type: application/json;charset=UTF-8'
		);

		$curl = curl_init($address);
		curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_FORBID_REUSE, 1);
		curl_setopt($curl, CURLINFO_HEADER_OUT, 1);
		curl_setopt($curl, CURLOPT_HEADER, 1);
		curl_setopt($curl, CURLOPT_POST, 1);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $request_json);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		$status = curl_getinfo($curl, CURLINFO_HTTP_CODE );
		
		curl_close($curl);
		
		if($status != 200||$status<200||$status>299) // jeśli wystąpi błąd to zostanie wypisany
		{
			print_r($response);
			
		}
		
	}
	